<?php
include 'koneksi.php';
session_start();
if (!isset($_SESSION['status']) || $_SESSION['status'] !== "login") {
    header('location:login.php');
    exit();
}
if ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'admin') {
    header('Location: logout.php');
    exit();
}

$role = $_SESSION['role'];

// Query notifikasi berdasarkan role - TANPA JOIN KE OBAT
$query_notif = "SELECT n.* 
                FROM notifikasi n
                WHERE n.role = '$role'
                ORDER BY n.id_notif DESC";
$result_notif = mysqli_query($conn, $query_notif);

// Hitung jumlah notifikasi baru
$query_count = "SELECT COUNT(*) as total 
                FROM notifikasi 
                WHERE role = '$role' AND status = 'BARU'";
$result_count = mysqli_query($conn, $query_count);
$count_data = mysqli_fetch_assoc($result_count);
$jumlah_notif_baru = $count_data['total'];
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Stockify</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="codedthemes">
    <link rel="icon" href="assets/images/logo.png" type="image/x-icon">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap"
        id="main-font-link">
    <link rel="stylesheet" href="assets/fonts/tabler-icons.min.css">
    <link rel="stylesheet" href="assets/fonts/feather.css">
    <link rel="stylesheet" href="assets/fonts/fontawesome.css">
    <link rel="stylesheet" href="assets/fonts/material.css">
    <link rel="stylesheet" href="assets/css/style.css" id="main-style-link">
    <link rel="stylesheet" href="assets/css/style-preset.css">
</head>
<body>
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <nav class="pc-sidebar">
        <div class="navbar-wrapper">
            <div class="m-header">
                <a href="dashboard.php" class="b-brand text-primary">
                    <img src="assets/images/banner.png" style="width: 190px;">
                </a>
            </div>
            <div class="navbar-content">
                <ul class="pc-navbar">
                    <li class="pc-item pc-caption">
                        <label>Home</label>
                        <i class="ti ti-dashboard"></i>
                    </li>
                    <li class="pc-item">
                        <a href="dashboard.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-dashboard"></i></span>
                            <span class="pc-mtext">Dashboard</span>
                        </a>
                    </li>
                    <li class="pc-item pc-caption">
                        <label>Master Data</label>
                        <i class="ti ti-dashboard"></i>
                    </li>
                    <li class="pc-item">
                        <a href="obat.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-pill"></i></span>
                            <span class="pc-mtext">Obat</span>
                        </a>
                    </li>
                    <li class="pc-item">
                        <a href="stok.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-stack"></i></span>
                            <span class="pc-mtext">Stok</span>
                        </a>
                    </li>
                    <li class="pc-item">
                        <a href="gudang.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-building-warehouse"></i></span>
                            <span class="pc-mtext">Gudang</span>
                        </a>
                    </li>
                    <li class="pc-item">
                        <a href="supplier.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-plus"></i></span>
                            <span class="pc-mtext">supplier</span>
                        </a>
                    </li>
                    <li class="pc-item">
                        <a href="scan.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-barcode"></i></span>
                            <span class="pc-mtext">Scan</span>
                        </a>
                    </li>
                    <li class="pc-item pc-caption">
                        <label>Transaksi</label>
                        <i class="ti ti-dashboard"></i>
                    </li>
                    <li class="pc-item">
                        <a href="pembelian.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-login"></i></span>
                            <span class="pc-mtext">Pembelian</span>
                        </a>
                    </li>
                    <li class="pc-item">
                        <a href="pengeluaran.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-adjustments-alt"></i></span>
                            <span class="pc-mtext">Mutasi</span>
                        </a>
                    </li>
                    <li class="pc-item pc-caption">
                        <label>Perhitungan</label>
                        <i class="ti ti-dashboard"></i>
                    </li>
                    <li class="pc-item">
                        <a href="eoq.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-rotate-clockwise"></i></span>
                            <span class="pc-mtext">EOQ</span>
                        </a>
                    </li>
                    <li class="pc-item">
                        <a href="rop.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-refresh"></i></span>
                            <span class="pc-mtext">ROP</span>
                        </a>
                    </li>
                    <li class="pc-item pc-caption">
                        <label>Users</label>
                        <i class="ti ti-dashboard"></i>
                    </li>
                    <li class="pc-item">
                        <a href="pengguna.php" class="pc-link">
                            <span class="pc-micon"><i class="ti ti-users"></i></span>
                            <span class="pc-mtext">Pengguna</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    <header class="pc-header">
        <div class="header-wrapper">
            <div class="me-auto pc-mob-drp">
                <ul class="list-unstyled">
                    <li class="pc-h-item header-mobile-collapse">
                        <a href="#" class="pc-head-link head-link-secondary ms-0" id="sidebar-hide">
                            <i class="ti ti-menu-2"></i>
                        </a>
                    </li>
                    <li class="pc-h-item pc-sidebar-popup">
                        <a href="#" class="pc-head-link head-link-secondary ms-0" id="mobile-collapse">
                            <i class="ti ti-menu-2"></i>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="ms-auto">
                <ul class="list-unstyled">
                    <li class="dropdown pc-h-item">
                        <a class="pc-head-link head-link-secondary dropdown-toggle arrow-none me-0" 
                           data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                            <i class="ti ti-bell"></i>
                            <?php if ($jumlah_notif_baru > 0): ?>
                                <span class="badge bg-danger rounded-pill position-absolute" style="top: 5px; right: 5px; font-size: 0.65rem;">
                                    <?= $jumlah_notif_baru > 99 ? '99+' : $jumlah_notif_baru ?>
                                </span>
                            <?php endif; ?>
                        </a>
                        <div class="dropdown-menu dropdown-notification dropdown-menu-end pc-h-dropdown" style="width: 400px;">
                            <div class="dropdown-header d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">
                                    Notifikasi 
                                    <?php if ($jumlah_notif_baru > 0): ?>
                                        <span class="badge bg-warning rounded-pill ms-1"><?= $jumlah_notif_baru ?></span>
                                    <?php endif; ?>
                                </h5>
                                <?php if ($jumlah_notif_baru > 0): ?>
                                    <a href="javascript:void(0)" onclick="bacaSemuaNotifikasi()" 
                                       class="link-primary text-decoration-underline" style="font-size: 0.875rem;">
                                        Baca Semua
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="dropdown-header px-0 text-wrap header-notification-scroll position-relative" 
                                 style="max-height: calc(100vh - 215px); overflow-y: auto;">
                                <?php if (mysqli_num_rows($result_notif) > 0): ?>
                                    <?php while ($notif = mysqli_fetch_assoc($result_notif)): ?>
                                        <div class="notification-item p-3 border-bottom <?= $notif['status'] == 'BARU' ? 'unread' : '' ?>" 
                                             onclick="bacaNotifikasi(<?= $notif['id_notif'] ?>)">
                                            <div class="d-flex align-items-start">
                                                <div class="flex-shrink-0">
                                                    <?php
                                                    $icon = 'ti-bell';
                                                    $bg_color = 'bg-primary';
                                                    if ($notif['kategori'] == 'STOK_MINIMUM') {
                                                        $icon = 'ti-alert-triangle';
                                                        $bg_color = 'bg-warning';
                                                    } elseif ($notif['kategori'] == 'KADALUWARSA') {
                                                        $icon = 'ti-calendar-x';
                                                        $bg_color = 'bg-danger';
                                                    } elseif ($notif['kategori'] == 'PEMBELIAN_BARU' || $notif['kategori'] == 'PEMBELIAN_DIKONFIRMASI') {
                                                        $icon = 'ti-shopping-cart';
                                                        $bg_color = 'bg-success';
                                                    }
                                                    ?>
                                                    <div class="avtar avtar-s <?= $bg_color ?>">
                                                        <i class="ti <?= $icon ?>"></i>
                                                    </div>
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <div class="d-flex justify-content-between align-items-center mb-1">
                                                        <span class="badge kategori-badge <?= $bg_color ?> text-white">
                                                            <?= str_replace('_', ' ', $notif['kategori']) ?>
                                                        </span>
                                                        <?php if ($notif['status'] == 'BARU'): ?>
                                                            <span class="badge bg-info" style="font-size: 0.65rem;">BARU</span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <!-- NAMA OBAT DIHAPUS - HANYA TAMPILKAN PESAN -->
                                                    <div class="notification-text text-muted">
                                                        <?= nl2br(htmlspecialchars($notif['pesan'])) ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <div class="text-center py-4">
                                        <i class="ti ti-bell-off" style="font-size: 3rem; color: #ccc;"></i>
                                        <p class="text-muted mt-2">Tidak ada notifikasi</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </li>
                    <li class="dropdown pc-h-item header-user-profile">
                        <a class="pc-head-link head-link-primary dropdown-toggle arrow-none me-0" data-bs-toggle="dropdown"
                            href="#" role="button" aria-haspopup="false" aria-expanded="false">
                            <img src="assets/images/user.png" alt="user-image" class="user-avtar">
                            <span><i class="ti ti-settings"></i></span>
                        </a>
                        <div class="dropdown-menu dropdown-user-profile dropdown-menu-end pc-h-dropdown">
                            <div class="dropdown-header text-center">
                                <h4>Selamat Datang, <span class="medium text-muted"><?= $_SESSION['username'] ?></span></h4>
                                <hr>
                                <div class="profile-notification-scroll position-relative"
                                    style="max-height: calc(100vh - 280px)">
                                    <a href="logout.php" class="dropdown-item">
                                        <i class="ti ti-logout"></i>
                                        <span>Logout</span>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>
    </header>